subroutine temp_Verlet
  use common_var
  implicit real*8 (a-z)
  real*8 time,e
  real*8 sumEkin,sumn,kT
  character(4) s
  integer i,j1,j,iter, new_j, new_jj
  integer rand1,rand2
  allocate (vx(at_count),vy(at_count),vz(at_count))
  allocate (vfx(at_count),vfy(at_count),vfz(at_count))
  print*, 'Input temp(K)=', temp
  print*, 'Time Step=', dt

  kT=temp/11602.d0
  sumEkin=0.d0; sumn=0.d0
  call set_rand(8732,8976)
  print*, "RANDOM GENERATOR:"
  print*, "Input two integer numbers (example: 1986 5417):"
  read(*,*) rand1, rand2
  call set_rand(rand1,rand2)
  s='HCNO'

  do i=1,at_count
    vx(i)=0.d0; vy(i)=0.d0; vz(i)=0.d0
  enddo

  
  time=0.d0; iter=0; call force(e)
  do new_j=1, MaxStepToWrite_MD 
      do new_jj=1, StepToWrite_MD
          do j=1,at_count
              x(j)=x(j)+vx(j)*dt+0.5d0*fx(j)*dt*dt/atmass(at_type(j))
              y(j)=y(j)+vy(j)*dt+0.5d0*fy(j)*dt*dt/atmass(at_type(j))
              z(j)=z(j)+vz(j)*dt+0.5d0*fz(j)*dt*dt/atmass(at_type(j))
              vfx(j)=fx(j); vfy(j)=fy(j); vfz(j)=fz(j)
          enddo
          call force(e)
          do j=1,at_count
              vx(j)=vx(j)+0.5d0*dt*(vfx(j)+fx(j))/atmass(at_type(j))
              vy(j)=vy(j)+0.5d0*dt*(vfy(j)+fy(j))/atmass(at_type(j))
              vz(j)=vz(j)+0.5d0*dt*(vfz(j)+fz(j))/atmass(at_type(j))
          enddo
          time=time+dt; iter=iter+1
      enddo
      
      print*, 'Iteration =', iter,'; ', 'time (fs)=', time
      call wri_crd_MD(time,new_j)

      if  (mod(iter,100).eq.0) then
          do j1=1,at_count
              vx(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
              vy(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
              vz(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
          enddo
      endif

      Ekin=0.d0
      do i=1,at_count
          Ekin=Ekin+0.5d0*atmass(at_type(i))*(vx(i)**2.d0+vy(i)**2.d0+vz(i)**2.d0)
      enddo
      sumEkin=sumEkin+Ekin; sumn=sumn+1.d0
      print*,'<Ekin> (eV)= ',sumEkin/sumn
      print*,'T (K)=',2.d0*sumEkin*11602.d0/(sumn*3.d0*dfloat(at_count))

  enddo

  deallocate (vx,vy,vz,vfx,vfy,vfz)
  print*, '*****************************************'
  print*, 'MOLELUCLAR DYNAMIC CALCULATIONS COMPLETE!'
  call EXIT()
end subroutine temp_Verlet







real*8 function gaus (centre,disp) 
  implicit real*8(a-z)
  real*8 centre,disp,ro,x,pi,r     
  pi=3.14159265359d0
  r=rndm()
  ro=dsqrt(-dlog(r))
  r=rndm()
  x=ro*dcos(2.d0*pi*r)
  x=centre+x*dsqrt(2.d0*disp)
  gaus=x
end function gaus
 
subroutine set_rand(IJ,KL)
   integer ij,kl,i97,j97,i7,k7,j7,l7,ii7,jj7,m7
   double precision c, cd,cm,r1,r2,s,tt,ugen
   common/UGEN/UGEN(97),C,CD,CM
   common/UGEN1/r1,r2
   common/UGEN2/I97,J97
   if ( IJ<0 .OR. IJ>31328 .OR. KL<0 .OR. KL>30081) then
      print '(A)',' The first seed must be between 0 and 31328'
      print '(A)',' The second seed must be between 0 and 30081'
      stop
    endif
    I7=MOD(IJ/177,177)+2 
    J7=MOD(IJ,177)+2
    K7=MOD(KL/169,178)+1
    L7=MOD(KL,169)
    do ii7=1,97
       S=0.D0
       Tt=0.5D0
       do jj7=1,24
          M7=MOD(MOD(I7*J7,179)*K7,179)
          I7=J7
          J7=K7 
          K7=M7 
          L7=MOD(53*L7+1,169)
          if (MOD(L7*M7,64)>32) S=S+Tt
          Tt=0.5D0*Tt
        enddo
        UGEN(ii7)=S
     enddo
     C=362436.D0/16777216.D0
     CD=7654321.D0/16777216.D0
     CM=16777213.D0/16777216.D0
     I97=97
     J97=33
     r1=5.d-15
     r2=1.d-14
     return
end subroutine set_rand
      
real*8 function rndm()
   double precision c, cd,cm,r1,r2,ugen,rval
   common/UGEN/UGEN(97), C, CD, CM
   common/UGEN1/r1,r2
   common/UGEN2/I97, J97
   integer i97,j97
   RVAL=UGEN(I97)-UGEN(J97)
   if (RVAL<0.D0) RVAL=RVAL+1.0d0
   UGEN(I97)=RVAL 
   I97=I97-1
   if (I97==0) I97=97
   J97=J97-1; if (J97 == 0) J97=97
   C=C-CD; if (C < 0.D0 ) C=C+CM
   RVAL=RVAL-C
   if ( RVAL .LT. 0.D0 ) RVAL = RVAL + 1.0d0
   rndm=max(RVAL-r1,r2)
   return
end function rndm
