!c           1S1S, 1S2S,1S2P,2S2S, 2S2P, 2P2Pq, 2p2Ppi
!c    R-, i,j -   (1=H; 2=C; 3=N; 4=O; In -   -  )
!c **********************************************************************
    subroutine In1S1S(R,In)
    use param
    real*8 R,p,ks,In
       ks=ksi(1,1); p=ks*R
       In=(1.d0+p+p*p/3.d0)*dexp(-p)
    end subroutine In1S1S
!c **********************************************************************
    subroutine In1S2S(R,i,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In
    integer i
        ks=(ksi(1,1)+ksi(i,1))/2.d0
        t=(ksi(1,1)-ksi(i,1))/(2.d0*ks)
        k=(t+1.d0/t)/2.d0
        p1=R*ksi(1,1); p2=R*ksi(i,1); p=ks*R 
        hlp1=dsqrt(1-t*t)/(dsqrt(3.d0)*t*p)
        hlp2=2.d0*(1.d0+k)*(2.d0-3.d0*k)
        hlp2=hlp2+(1.d0-2.d0*k)*p1
        hlp2=-(1.d0-k)*hlp2*dexp(-p1)
        hlp3=2.d0*(1.d0-k)*(2.d0-3.d0*k)
        hlp3=hlp3+4.d0*(1.d0-k)*p2+p2*p2
        hlp3=(1.d0+k)*hlp3*dexp(-p2)
        In=hlp1*(hlp2+hlp3)
    end subroutine In1S2S
!c **********************************************************************
    subroutine dIn1S2S(R,i,In)
    use param
    real*8:: R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In,dh2,dh3
    integer i
        ks=(ksi(1,1)+ksi(i,1))/2.d0
        t=(ksi(1,1)-ksi(i,1))/(2.d0*ks)
        k=(t+1.d0/t)/2.d0
        p1=R*ksi(1,1); p2=R*ksi(i,1); p=ks*R 
        hlp1=dsqrt(1-t*t)/(dsqrt(3.d0)*t*p)
        hlp2=2.d0*(1.d0+k)*(2.d0-3.d0*k)
        hlp2=hlp2+(1.d0-2.d0*k)*p1
        hlp2=-(1.d0-k)*hlp2*dexp(-p1)
 
            dh2=-ksi(1,1)*(hlp2+(1.d0-2.d0*k)*(1.d0-k)*dexp(-p1))
        hlp3=2.d0*(1.d0-k)*(2.d0-3.d0*k)
        hlp3=hlp3+4.d0*(1.d0-k)*p2+p2*p2
        hlp3=(1.d0+k)*hlp3*dexp(-p2)
            dh3=ksi(i,1)*(-hlp3+(1.d0+k)*dexp(-p2)*(4.d0*(1.d0-k)+2.d0*p2))  

        In=hlp1*(hlp2+hlp3)
            in=-in/R+hlp1*(dh2+dh3)
    end subroutine dIn1S2S

! **********************************************************************
    subroutine In1S2P(R,i,In)
    use param
    real*8 R,p,ks,k,kk,t,tt,p1,p2,hlp2,hlp3,In
    integer i
      ks=(ksi(1,1)+ksi(i,2))/2.d0
      t=(ksi(1,1)-ksi(i,2))/(2.d0*ks)
      k=(t+1.d0/t)/2.d0
      p1=ksi(1,1); p2=ksi(i,2); p=ks 
      tt=dsqrt((1.d0+t)/(1.d0-t))/(t*p*p)
          kk=(1.d0-k)*(1.d0-k) 
      hlp2=tt*kk*(6.d0*(1.d0+k)*(1.d0/R**3+p1/R**2)+2.d0*p1*p1/R)
      hlp3=(1.d0+k)*tt*(6.d0*kk*(1.d0/R**3+p2/R**2)+4.d0*(1.d0-k)*p2*p2/R+p2*p2*p2)

        In=hlp2*dexp(-p1*R)-hlp3*dexp(-p2*R)  !  
    end subroutine In1S2P
! **********************************************************************
    subroutine dIn1S2P(R,i,In)
    use param
    real*8 R,p,ks,k,kk,t,tt,p1,p2,hlp2,hlp3,In
    integer i
      ks=(ksi(1,1)+ksi(i,2))/2.d0
      t=(ksi(1,1)-ksi(i,2))/(2.d0*ks)
      k=(t+1.d0/t)/2.d0
      p1=ksi(1,1); p2=ksi(i,2); p=ks 
      tt=dsqrt((1.d0+t)/(1.d0-t))/(t*p*p)
          kk=(1.d0-k)*(1.d0-k) 

      hlp2=tt*kk*(6.d0*(1.d0+k)*(1.d0/R**3+p1/R**2)+2.d0*p1*p1/R)
      hlp3=(1.d0+k)*tt*(6.d0*kk*(1.d0/R**3+p2/R**2)+4.d0*(1.d0-k)*p2*p2/R+p2*p2*p2)
          In=-p1*hlp2*dexp(-p1*R)+p2*hlp3*dexp(-p2*R)

      hlp2=tt*kk*(6.d0*(1.d0+k)*(-3.d0/R**4-2.d0*p1/R**3)-2.d0*p1*p1/R**2)
      hlp3=(1.d0+k)*tt*(6.d0*kk*(-3.d0/R**4-2.d0*p2/R**3)-4.d0*(1.d0-k)*p2*p2/R**2 )
          In=In+hlp2*dexp(-p1*R)-hlp3*dexp(-p2*R)  !  

    end subroutine dIn1S2P

!c ***********************************************************************
    subroutine In2S2S(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In,Rm1,R00,R1,R2,R3,R4
    integer i,j

    if (dabs(ksi(i,1)-ksi(j,1)).lt.0.1d0) then
          ks=(ksi(i,1)+ksi(j,1))/2.d0
              p=ks;R00=1.d0; R1=p; R2=4.d0*p*p/9.d0; R3=p*p*p/9.d0;  R4=p*p*p*p/45.d0
          hlp1=R00+R1*R+R2*R**2+R3*R**3+R4*R**4 
          hlp1=hlp1*dexp(-p*R)
          In=hlp1
        endif

        if (i.ne.j) then
            ks=(ksi(i,1)+ksi(j,1))/2.d0
          t=(ksi(i,1)-ksi(j,1))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1)
                  p2=ksi(j,1)
                  p=ks 
          hlp1=dsqrt(1-t*t)/(3.d0*t*p)
              Rm1=-(1.d0-k)*2.d0*(1.d0+k)*(7.d0-12.d0*k*k)*hlp1
              R00=-(1.d0-k)*4.d0*(1.d0+k)*(2.d0-3.d0*k)*p1*hlp1
              R1=-hlp1*(1.d0-k)*(1.d0-2.d0*k)*p1*p1 
           hlp2=Rm1/R+R00+R1*R

              Rm1=(1.d0+k)*2.d0*(1.d0-k)*(7.d0-12.d0*k*k)*hlp1 
              R00=hlp1*(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2 
              R1=hlp1*(1.d0+k)*(1.d0+2.d0*k)*p2*p2
          hlp3=Rm1/R+R00+R1*R
              
          In=hlp2*dexp(-p1*R)+hlp3*dexp(-p2*R)
        endif
    end subroutine In2S2S
!c ***********************************************************************
    subroutine dIn2S2S(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In,Rm1,R00,R1,R2,R3,R4
        real*8  dhlp1,dhlp2,dhlp3 
    integer i,j

    if (dabs(ksi(i,1)-ksi(j,1)).lt.0.1d0) then
          ks=(ksi(i,1)+ksi(j,1))/2.d0
              p=ks;R00=1.d0; R1=p; R2=4.d0*p*p/9.d0; R3=p*p*p/9.d0;  R4=p*p*p*p/45.d0
          hlp1=R00+R1*R+R2*R**2+R3*R**3+R4*R**4 
              dhlp1=R1+2.d0*R2*R+3.d0*R3*R**2+4.d0*R4*R**3  
          In=dhlp1*dexp(-p*R)-p*hlp1*dexp(-p*R)
        endif

        if (i.ne.j) then
            ks=(ksi(i,1)+ksi(j,1))/2.d0
          t=(ksi(i,1)-ksi(j,1))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1)
                  p2=ksi(j,1)
                  p=ks 
          hlp1=dsqrt(1-t*t)/(3.d0*t*p)
              Rm1=-(1.d0-k)*2.d0*(1.d0+k)*(7.d0-12.d0*k*k)*hlp1
              R00=-(1.d0-k)*4.d0*(1.d0+k)*(2.d0-3.d0*k)*p1*hlp1
              R1=-hlp1*(1.d0-k)*(1.d0-2.d0*k)*p1*p1 
          hlp2=Rm1/R+R00+R1*R
              dhlp2=-Rm1/R**2+R1

              Rm1=(1.d0+k)*2.d0*(1.d0-k)*(7.d0-12.d0*k*k)*hlp1 
              R00=hlp1*(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2 
              R1=hlp1*(1.d0+k)*(1.d0+2.d0*k)*p2*p2
           hlp3=Rm1/R+R00+R1*R
              dhlp3=-Rm1/R**2+R1  
              
           In=dhlp2*dexp(-p1*R)-p1*hlp2*dexp(-p1*R) +dhlp3*dexp(-p2*R)-p2*hlp3*dexp(-p2*R)
        endif
    end subroutine dIn2S2S

!c ***********************************************************************
    subroutine In2S2P(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In
    real*8 kk1,kk2,kk3,kk4 
    integer i,j
        if (i.eq.j) then
          ks=(ksi(i,1)+ksi(j,2))/2.d0
          t=(ksi(i,1)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1); p2=ksi(j,2); p=ks 
          hlp1=dsqrt((1.d0+t)/(1.d0-t))
          hlp1=hlp1/(dsqrt(3.d0)*t*p*p)

              kk1=-(1.d0-k)**2*6.d0*(1.d0+k)*(3.d0+4.d0*k)
              kk2=kk1*p1
              kk3=-(1.d0-k)**2*2.d0*(5.d0+6.d0*k)*p1*p1 
              kk4=-(1.d0-k)**2*2.d0*p1*p1*p1
          hlp2=kk1/R**3+kk2/R**2+kk3/R+kk4
          hlp2=hlp2*dexp(-p1*R)

              kk1=(1.d0+k)*6.d0*(1.d0-k)*(1.d0-k)*(3.d0+4.d0*k)
              kk2=kk1*p2   
              kk3=(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2*p2  
              kk4=(1.d0+k)*(1.d0+2.d0*k)*p2*p2*p2
          hlp3=kk1/R**3+kk2/R**2+kk3/R+kk4
          hlp3=hlp3*dexp(-p2*R)

          In=-hlp1*(hlp2+hlp3) !  
        endif

        if (i.ne.j) then
          ks=(ksi(i,1)+ksi(j,2))/2.d0
          t=(ksi(i,1)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1); p2=ksi(j,2); p=ks 
          hlp1=dsqrt((1.d0+t)/(1.d0-t))
          hlp1=hlp1/(dsqrt(3.d0)*t*p*p)
          kk1=-(1.d0-k)*(1.d0-k)*6.d0*(1.d0+k)*(3.d0+4.d0*k)
              kk2=kk1*p1
              kk3=-(1.d0-k)*(1.d0-k)*2.d0*(5.d0+6.d0*k)*p1*p1 
              kk4=-(1.d0-k)*(1.d0-k)*2.d0*p1*p1*p1
          hlp2=kk1/R**3+kk2/R**2+kk3/R+kk4
          hlp2=hlp2*dexp(-p1*R)

          kk1=(1.d0+k)*6.d0*(1.d0-k)*(1.d0-k)*(3.d0+4.d0*k)
          kk2=kk1*p2
              kk3=(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2*p2    
              kk4=(1.d0+k)*(1.d0+2.d0*k)*p2*p2*p2
          hlp3=kk1/R**3+kk2/R**2+kk3/R+kk4
          hlp3=hlp3*dexp(-p2*R)

          In=-hlp1*(hlp2+hlp3)  !  
        endif

        IF (dabs(ksi(i,1)-ksi(j,2)).lt.0.2d0) THEN
          ks=(ksi(i,1)+ksi(j,2))/2.d0; p=ks 
          kk1=p/(2.d0*dsqrt(3.d0))
              kk2=kk1*p
              kk3=kk1*7.d0*p*p/15.d0 
              kk4=kk1*2.d0*p*p*p/15.d0
              In=kk1+kk2*R+kk3*R**2+kk4*R**3
              In=In*dexp(-p*R)
          In=-In  !  
        ENDIF

    end subroutine In2S2P
!c ***********************************************************************
    subroutine dIn2S2P(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In
    real*8 kk1,kk2,kk3,kk4 
    integer i,j
        if (i.eq.j) then
          ks=(ksi(i,1)+ksi(j,2))/2.d0
          t=(ksi(i,1)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1); p2=ksi(j,2); p=ks 
          hlp1=dsqrt((1.d0+t)/(1.d0-t))
          hlp1=hlp1/(dsqrt(3.d0)*t*p*p)

              kk1=-(1.d0-k)**2*6.d0*(1.d0+k)*(3.d0+4.d0*k)
              kk2=kk1*p1
              kk3=-(1.d0-k)**2*2.d0*(5.d0+6.d0*k)*p1*p1 
              kk4=-(1.d0-k)**2*2.d0*p1*p1*p1
          hlp2=-p1*(kk1/R**3+kk2/R**2+kk3/R+kk4)
              hlp2=hlp2-3.d0*kk1/R**4-2.d0*kk2/R**3-kk3/R**2
          hlp2=hlp2*dexp(-p1*R)

              kk1=(1.d0+k)*6.d0*(1.d0-k)*(1.d0-k)*(3.d0+4.d0*k)
              kk2=kk1*p2   
              kk3=(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2*p2  
              kk4=(1.d0+k)*(1.d0+2.d0*k)*p2*p2*p2
          hlp3=-p2*(kk1/R**3+kk2/R**2+kk3/R+kk4)
              hlp3=hlp3-3.d0*kk1/R**4-2.d0*kk2/R**3-kk3/R**2
          hlp3=hlp3*dexp(-p2*R)

          In=-hlp1*(hlp2+hlp3) !  
        endif

        if (i.ne.j) then
          ks=(ksi(i,1)+ksi(j,2))/2.d0
          t=(ksi(i,1)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,1); p2=ksi(j,2); p=ks 
          hlp1=dsqrt((1.d0+t)/(1.d0-t))
          hlp1=hlp1/(dsqrt(3.d0)*t*p*p)
          kk1=-(1.d0-k)*(1.d0-k)*6.d0*(1.d0+k)*(3.d0+4.d0*k)
              kk2=kk1*p1
              kk3=-(1.d0-k)*(1.d0-k)*2.d0*(5.d0+6.d0*k)*p1*p1 
              kk4=-(1.d0-k)*(1.d0-k)*2.d0*p1*p1*p1
          hlp2=-p1*(kk1/R**3+kk2/R**2+kk3/R+kk4)
              hlp2=hlp2-3.d0*kk1/R**4-2.d0*kk2/R**3-kk3/R**2
          hlp2=hlp2*dexp(-p1*R)

          kk1=(1.d0+k)*6.d0*(1.d0-k)*(1.d0-k)*(3.d0+4.d0*k)
          kk2=kk1*p2
              kk3=(1.d0+k)*4.d0*(1.d0-k)*(2.d0+3.d0*k)*p2*p2    
              kk4=(1.d0+k)*(1.d0+2.d0*k)*p2*p2*p2
          hlp3=-p2*(kk1/R**3+kk2/R**2+kk3/R+kk4)
              hlp3=hlp3-3.d0*kk1/R**4-2.d0*kk2/R**3-kk3/R**2
          hlp3=hlp3*dexp(-p2*R)

          In=-hlp1*(hlp2+hlp3)  !  
        endif

        IF (dabs(ksi(i,1)-ksi(j,2)).lt.0.2d0) THEN
          ks=(ksi(i,1)+ksi(j,2))/2.d0; p=ks 
          kk1=p/(2.d0*dsqrt(3.d0))
              kk2=kk1*p
              kk3=kk1*7.d0*p*p/15.d0 
              kk4=kk1*2.d0*p*p*p/15.d0
              In=-p*(kk1+kk2*R+kk3*R**2+kk4*R**3)
              In=In+kk2+2.d0*kk3*R+3.d0*kk4*R**2 
              In=In*dexp(-p*R)
          In=-In  !  
        ENDIF

    end subroutine dIn2S2P

!c ***********************************************************************
    subroutine In2P2Pq(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In
    real*8 kk1,kk2,kk3,kk4,kk5
    integer i,j
!c        if (i.eq.j) then
        if (dabs(ksi(i,2)-ksi(j,2)).lt.0.1d0) then
            ks=(ksi(i,2)+ksi(j,2))/2.d0; p=ks
        kk1=-1.d0
        kk2=-p
        kk3=-p*p/5.d0
    kk4=2.d0*p*p*p/15.d0
    kk5=p*p*p*p/15.d0    
             hlp1=kk1/R**2+kk2/R+kk3 +kk4*R +kk5*R**2
          In=-hlp1*dexp(-p*R)   !  

        endif
        if (i.ne.j) then
          ks=(ksi(i,2)+ksi(j,2))/2.d0
          t=(ksi(i,2)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,2); p2=ksi(j,2); p=ks 
          hlp1=1.d0/(dsqrt(1.d0-t*t)*t*p*p*p)
          kk1=-hlp1*(-(1.d0-k))*(1.d0-k)*48.d0*(1.d0+k)*(1.d0+k)
              kk2=kk1*p1
              kk3=kk1*p1**2/2.d0
              kk4=-hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*(5.d0+6.d0*k)*p1*p1*p1 
              kk5=-hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*p1*p1*p1*p1
          hlp2=kk1/R**5+kk2/R**4+kk3/R**3 +kk4/R**2  +kk5/R 
          hlp2=hlp2*dexp(-p1*R)

          kk1=-hlp1*(1.d0+k)*(1.d0+k)*48.d0*(1.d0-k)*(1.d0-k)
              kk2=kk1*p2
              kk3=kk1*p2**2/2.d0
              kk4=-hlp1*(1.d0+k)*(1.d0+k)*2.d0*(5.d0-6.d0*k)*p2*p2*p2
          kk5=-hlp1*(1.d0+k)*(1.d0+k)*2.d0*p2*p2*p2*p2  
          hlp3=kk1/R**5 +kk2/R**4 +kk3/R**3 +kk4/R**2  +kk5/R 
          hlp3=hlp3*dexp(-p2*R)

          In=  hlp2+hlp3 !      
        endif

    end subroutine In2P2Pq
!c ***********************************************************************
    subroutine In2P2Ppi(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In
    real*8 kk1,kk2,kk3,kk4
    integer i,j

!c        if (i.eq.j) then
        if (dabs(ksi(i,2)-ksi(j,2)).lt.0.1d0) then
            ks=(ksi(i,2)+ksi(j,2))/2.d0; p=ks
          kk1=1.d0  
          kk2=p  
          kk3=2.d0*p*p/5.d0
          kk4=p*p*p/15.d0    
            hlp2=kk1/R**2+kk2/R+kk3 +kk4*R 
          In=hlp2*dexp(-p*R)
        endif

        if (i.ne.j) then
          ks=(ksi(i,2)+ksi(j,2))/2.d0
          t=(ksi(i,2)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,2); p2=ksi(j,2); p=ks 
          hlp1=1.d0/(dsqrt(1.d0-t*t)*t*p*p*p)
          kk1=hlp1*(-(1.d0-k))*(1.d0-k)*24.d0*(1.d0+k)*(1.d0+k) 
              kk2=kk1*p1
              kk3=hlp1*(-(1.d0-k))*(1.d0-k)*12.d0*(1.d0+k)*p1*p1
              kk4=hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*p1*p1*p1 
          hlp2=kk1/R**5+kk2/R**4+kk3/R**3+kk4/R**2 
          hlp2=hlp2*dexp(-p1*R)
              kk1=hlp1*(1.d0+k)*(1.d0+k)*24.d0*(1.d0-k)*(1.d0-k)
              kk2=kk1*p2 
              kk3=hlp1*(1.d0+k)*(1.d0+k)*12.d0*(1.d0-k)*p2*p2
              kk4=hlp1*(1.d0+k)*(1.d0+k)*2.d0*p2*p2*p2  
              hlp3=kk1/R**5 +kk2/R**4 +kk3/R**3 +kk4/R**2 
          hlp3=hlp3*dexp(-p2*R)
          In=hlp2+hlp3



        endif

    end subroutine In2P2Ppi
!c ***********************************************************************
    subroutine dIn2P2Pq(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In,dhlp
    real*8 kk1,kk2,kk3,kk4,kk5
    integer i,j
 
        if (dabs(ksi(i,2)-ksi(j,2)).lt.0.1d0) then
            ks=(ksi(i,2)+ksi(j,2))/2.d0; p=ks
        kk1=-1.d0
        kk2=-p
        kk3=-p*p/5.d0
    kk4=2.d0*p*p*p/15.d0
    kk5=p*p*p*p/15.d0    
             hlp1=kk1/R**2+kk2/R+kk3 +kk4*R +kk5*R**2
            dhlp=-2.d0*kk1/R**3-kk2/R**2+kk4 +2.d0*kk5*R
          In=-dhlp*dexp(-p*R)+p*hlp1*dexp(-p*R)   !  

        endif
        if (i.ne.j) then
          ks=(ksi(i,2)+ksi(j,2))/2.d0
          t=(ksi(i,2)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,2); p2=ksi(j,2); p=ks 
          hlp1=1.d0/(dsqrt(1.d0-t*t)*t*p*p*p)
          kk1=-hlp1*(-(1.d0-k))*(1.d0-k)*48.d0*(1.d0+k)*(1.d0+k)
              kk2=kk1*p1
              kk3=kk1*p1**2/2.d0
              kk4=-hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*(5.d0+6.d0*k)*p1*p1*p1 
              kk5=-hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*p1*p1*p1*p1
          hlp2=kk1/R**5+kk2/R**4+kk3/R**3 +kk4/R**2  +kk5/R 
     dhlp=-5.d0*kk1/R**6-4.d0*kk2/R**5-3.d0*kk3/R**4 -2.d0*kk4/R**3 -kk5/R**2 
 
          hlp2=dhlp*dexp(-p1*R)-p1*hlp2*dexp(-p1*R)

          kk1=-hlp1*(1.d0+k)*(1.d0+k)*48.d0*(1.d0-k)*(1.d0-k)
              kk2=kk1*p2
              kk3=kk1*p2**2/2.d0
              kk4=-hlp1*(1.d0+k)*(1.d0+k)*2.d0*(5.d0-6.d0*k)*p2*p2*p2
          kk5=-hlp1*(1.d0+k)*(1.d0+k)*2.d0*p2*p2*p2*p2  
          hlp3=kk1/R**5 +kk2/R**4 +kk3/R**3 +kk4/R**2  +kk5/R 
     dhlp=-5.d0*kk1/R**6-4.d0*kk2/R**5-3.d0*kk3/R**4 -2.d0*kk4/R**3 -kk5/R**2 
 
          hlp3=dhlp*dexp(-p2*R)-p2*hlp3*dexp(-p2*R)

          In=  hlp2+hlp3 !      
        endif

    end subroutine dIn2P2Pq
!c ***********************************************************************
    subroutine dIn2P2Ppi(R,i,j,In)
    use param
    real*8 R,p,ks,k,t,p1,p2,hlp1,hlp2,hlp3,In,dhlp
    real*8 kk1,kk2,kk3,kk4
    integer i,j

 
        if (dabs(ksi(i,2)-ksi(j,2)).lt.0.1d0) then
            ks=(ksi(i,2)+ksi(j,2))/2.d0; p=ks
          kk1=1.d0  
          kk2=p  
          kk3=2.d0*p*p/5.d0
          kk4=p*p*p/15.d0    
            hlp2=kk1/R**2+kk2/R+kk3 +kk4*R 
            dhlp=-2.d0*kk1/R**3-kk2/R**2+kk4 
 
          In=dhlp*dexp(-p*R)-p*hlp2*dexp(-p*R)
        endif

        if (i.ne.j) then
          ks=(ksi(i,2)+ksi(j,2))/2.d0
          t=(ksi(i,2)-ksi(j,2))/(2.d0*ks)
          k=(t+1.d0/t)/2.d0
          p1=ksi(i,2); p2=ksi(j,2); p=ks 
          hlp1=1.d0/(dsqrt(1.d0-t*t)*t*p*p*p)
          kk1=hlp1*(-(1.d0-k))*(1.d0-k)*24.d0*(1.d0+k)*(1.d0+k) 
              kk2=kk1*p1
              kk3=hlp1*(-(1.d0-k))*(1.d0-k)*12.d0*(1.d0+k)*p1*p1
              kk4=hlp1*(-(1.d0-k))*(1.d0-k)*2.d0*p1*p1*p1 
          hlp2=kk1/R**5+kk2/R**4+kk3/R**3+kk4/R**2 
          dhlp=-5.d0*kk1/R**6-4.d0*kk2/R**5-3.d0*kk3/R**4-2.d0*kk4/R**3 
 
          hlp2=dhlp*dexp(-p1*R)-p1*hlp2*dexp(-p1*R)
              kk1=hlp1*(1.d0+k)*(1.d0+k)*24.d0*(1.d0-k)*(1.d0-k)
              kk2=kk1*p2 
              kk3=hlp1*(1.d0+k)*(1.d0+k)*12.d0*(1.d0-k)*p2*p2
              kk4=hlp1*(1.d0+k)*(1.d0+k)*2.d0*p2*p2*p2  
              hlp3=kk1/R**5 +kk2/R**4 +kk3/R**3 +kk4/R**2 
          dhlp=-5.d0*kk1/R**6-4.d0*kk2/R**5-3.d0*kk3/R**4-2.d0*kk4/R**3 
 
          hlp3=dhlp*dexp(-p2*R)-p2*hlp3*dexp(-p2*R)

          In=hlp2+hlp3



        endif

    end subroutine dIn2P2Ppi
!c ***********************************************************************

        subroutine wri_crd
    use  common_var
    
    logical :: exist

        inquire(file="coord.xyz", exist=exist)
        if (exist) then
            open(2, file="coord.xyz", status="old", position="append", action="write")
        else
            open(2, file="coord.xyz", status="new", action="write")
        end if
            do j=1,at_count
                if(at_type(j)==1) write(2,1) x(j),y(j),z(j)
                if(at_type(j)==2) write(2,2) x(j),y(j),z(j)
                if(at_type(j)==3) write(2,3) x(j),y(j),z(j)
                if(at_type(j)==4) write(2,4) x(j),y(j),z(j)
            end do
        close(2)

            open(2, file="Period" )
    write(2,5) perx(1),pery(1),perz(1)
    write(2,6) perx(2),pery(2),perz(2)
    write(2,7) perx(3),pery(3),perz(3)
        close(2)


1       format(1x,'H', 3e20.8,3x)
2       format(1x,'C', 3e20.8,3x)
3       format(1x,'N', 3e20.8,3x)
4       format(1x,'O', 3e20.8,3x)
5       format(1x,'per vec 1', 3e20.8,3x)
6       format(1x,'per vec 2', 3e20.8,3x)
7       format(1x,'per vec 3', 3e20.8,3x)


        end  
!*********************************************************

        subroutine wri_crd_relax(energy, step_relax)
    use  common_var
    real*8, intent(in) :: energy
        integer, intent(in) :: step_relax
    
    logical :: exist
5       format("Step= ", i0,2x, "E= ", 1e16.8, ' [eV]',3x, "F= ", 1e16.8, ' [eV/A]')
        inquire(file="coord.xyz", exist=exist)
        if ((exist).and.(step_relax>1)) then
            open(2, file="coord.xyz", status="old", position="append", action="write")
        else
            open(2, file="coord.xyz", status="replace", action="write")
        end if
        write(2,*) at_count  
        write(2,5) step_relax, energy, sum(dabs(fx))+sum(dabs(fy))+sum(dabs(fz))
            do j=1,at_count
                if(at_type(j)==1) write(2,1) x(j),y(j),z(j)
                if(at_type(j)==2) write(2,2) x(j),y(j),z(j)
                if(at_type(j)==3) write(2,3) x(j),y(j),z(j)
                if(at_type(j)==4) write(2,4) x(j),y(j),z(j)
            end do
        close(2)
1       format(1x,'H', 3e20.8,3x)
2       format(1x,'C', 3e20.8,3x)
3       format(1x,'N', 3e20.8,3x)
4       format(1x,'O', 3e20.8,3x)

        end 
        
        
        
        subroutine wri_crd_relax_cif
        use  convert2frac
        use  common_var
        real(8) :: l_a, l_b, l_c, cos_BC, cos_AC, cos_AB
        real(8) :: cell_vector(3,3)
        real(8) :: CartCoord(at_count,3), FracCoord(at_count,3)
        
        do j = 1,3
            cell_vector(j,1) = perx(j)
            cell_vector(j,2) = pery(j)
            cell_vector(j,3) = perz(j)
        enddo
        
        do j = 1,at_count
            CartCoord(j,1) = x(j)
            CartCoord(j,2) = y(j)
            CartCoord(j,3) = z(j)
        enddo
        
        l_a = sqrt(perx(1)**2+pery(1)**2+perz(1)**2)
        l_b = sqrt(perx(2)**2+pery(2)**2+perz(2)**2)
        l_c = sqrt(perx(3)**2+pery(3)**2+perz(3)**2)
        cos_BC = (perx(2)*perx(3)+pery(2)*pery(3)+perz(2)*perz(3))/(l_b*l_c)
        cos_AC = (perx(1)*perx(3)+pery(1)*pery(3)+perz(1)*perz(3))/(l_a*l_c)
        cos_AB = (perx(1)*perx(2)+pery(1)*pery(2)+perz(1)*perz(2))/(l_a*l_b)
        
        call cart2frac(at_count, cell_vector, CartCoord, FracCoord)
                
        open(1, file='coord.cif')
            write(1,*) '_cell_length_a ', l_a
            write(1,*) '_cell_length_b ', l_b
            write(1,*) '_cell_length_c ', l_c
            write(1,*) '_cell_angle_alpha ', dacos(cos_BC)*180/pi
            write(1,*) '_cell_angle_beta ', dacos(cos_AC)*180/pi
            write(1,*) '_cell_angle_gamma ', dacos(cos_AB)*180/pi
            write(1,*) 'loop_'
            write(1,*) '_atom_site_label'
            write(1,*) '_atom_site_fract_x '
            write(1,*) '_atom_site_fract_y '
            write(1,*) '_atom_site_fract_z '
            do j=1,at_count
                if(at_type(j)==1) write(1,1) FracCoord(j,1),FracCoord(j,2),FracCoord(j,3)
                if(at_type(j)==2) write(1,2) FracCoord(j,1),FracCoord(j,2),FracCoord(j,3)
                if(at_type(j)==3) write(1,3) FracCoord(j,1),FracCoord(j,2),FracCoord(j,3)
                if(at_type(j)==4) write(1,4) FracCoord(j,1),FracCoord(j,2),FracCoord(j,3)
            end do
            
        close(1)

1       format(1x,'H', 3e20.8,3x)
2       format(1x,'C', 3e20.8,3x)
3       format(1x,'N', 3e20.8,3x)
4       format(1x,'O', 3e20.8,3x)
        
        end
!******************************************************************
!*********************************************************

        subroutine wri_crd_MD(time_MD, step_MD)
    use  common_var
    real*8, intent(in) :: time_MD
        integer, intent(in) :: step_MD
    
    logical :: exist

        inquire(file="coord.xyz", exist=exist)
        if ((exist).and.(step_MD>1)) then
            open(2, file="coord.xyz", status="old", position="append", action="write")
        else
            open(2, file="coord.xyz", status="replace", action="write")
        end if
        write(2,*) at_count  
        write(2,*) 'Step=', step_MD,'Time=', time_MD
            do j=1,at_count
                if(at_type(j)==1) write(2,1) x(j),y(j),z(j)
                if(at_type(j)==2) write(2,2) x(j),y(j),z(j)
                if(at_type(j)==3) write(2,3) x(j),y(j),z(j)
                if(at_type(j)==4) write(2,4) x(j),y(j),z(j)
            end do
        close(2)
1       format(1x,'H', 3e20.8,3x)
2       format(1x,'C', 3e20.8,3x)
3       format(1x,'N', 3e20.8,3x)
4       format(1x,'O', 3e20.8,3x)


        end 
!******************************************************************
        subroutine EISRS1(NM,N,D,ZR,IERR,E)
        !use a111
        use common_var
        implicit real*8(a-h,o-z)
        INTEGER NM,N,IERR
        dimension E(nm),D(nm),ZR(nm,nm)
!C       all eigenvalues and corresponding eigenvectors
!C    of reai symmetric matrix

           call TRED2(NM,N,D,E,ZR)

!        print *,'matrix obtained in threedigonal type'
        call TQL2(NM,N,D,E,ZR,IERR)
        return
          end
!*****************************************
      SUBROUTINE TRED2(NM,N,D,E,ZR)
      !use a111
      use common_var
        implicit real*8(a-h,o-z)
      INTEGER I,J,K,L,N,II,NM,JP1
      dimension D(nm),E(nm),ZR(nm,nm)
      
          
      IF (N .EQ. 1) GO TO 320
      DO  II = 2, N
      
         I = N + 2 - II
         L = I - 1
         H = 0.d0
         SCALE = 0.d0
         IF (L .LT. 2) GO TO 130

         DO  K = 1, L
 
         SCALE = SCALE + DABS(ZR(I,K))
         end do



         IF (SCALE .NE. 0.d0) GO TO 140
  130    E(I) = ZR(I,L)
         GO TO 290



  140    continue
  
            
            DO  K = 1, L
            ZR(I,K) = ZR(I,K) / SCALE
            H = H + ZR(I,K) * ZR(I,K)
           end do

         F = ZR(I,L)
         G = -DSIGN(DSQRT(H),F)
         E(I) = SCALE * G
         H = H - F * G
         ZR(I,L) = F - G
         F = 0.d0
         DO  J = 1, L
            ZR(J,I) = ZR(I,J) / (SCALE * H)
            G = 0.d0
            DO  K = 1, J
            G = G + ZR(J,K) * ZR(I,K)
            end do

            JP1 = J + 1
            IF (L .LT. JP1) then
            else
                  DO  K = JP1, L
                  G = G + ZR(K,J) * ZR(I,K)
                  end do
            end if
            E(J) = G / H
            F = F + E(J) * ZR(I,J)
         end do

         HH = F / (H + H)
         DO  J = 1, L
            F = ZR(I,J)
            G = E(J) - HH * F
            E(J) = G
            DO  K = 1, J
               ZR(J,K) = ZR(J,K) - F * E(K) - G * ZR(I,K)
         end do
         end do
         DO  K = 1, L
         ZR(I,K) = SCALE * ZR(I,K)
         end do
  290    D(I) = H


        end do
  

  320 D(1) = 0.d0
      E(1) = 0.d0
      DO  I = 1, N
         L = I - 1
         IF (D(I) .EQ. 0.d0) GO TO 380

         DO  J = 1, L
            G = 0.d0
            DO  K = 1, L
            G = G + ZR(I,K) * ZR(K,J)
            end do
            DO  K = 1, L
               ZR(K,J) = ZR(K,J) - G * ZR(K,I)
          end do
          end do

  380    D(I) = ZR(I,I)
         ZR(I,I) = 1.d0
         IF (L .LT. 1) cycle

         DO  J = 1, L
            ZR(I,J) = 0.d0
            ZR(J,I) = 0.d0
            end do
              end do
  
      RETURN
      END
!*****************************************************
      SUBROUTINE TQL2(NM,N,D,E,ZR,IERR)
      !use a111
            use common_var
        implicit real*8(a-h,o-z)
        real*8::MACHEP
      INTEGER I,J,K,L,M,N,II,NM,MML,IERR
      dimension D(nm),E(nm),ZR(nm,nm)
      MACHEP=2.d0**(-52)
      IERR = 0
      IF (N .EQ. 1) GO TO 1001
      DO  I = 2, N
      E(I-1) = E(I)
      end do
      F = 0.d0
      B = 0.d0
      E(N) = 0.d0

      DO 240 L = 1, N

         J = 0
         H = MACHEP * (DABS(D(L)) + DABS(E(L)))
         IF (B .LT. H) B = H
         DO  M = L, N
            IF (DABS(E(M)) .LE. B) exit
          end do
         IF (M .EQ. L) GO TO 220

  130    IF (J .EQ. 50) GO TO 1000
         J = J + 1
         P = (D(L+1) - D(L)) / (2.d0 * E(L))
         R = DSQRT(P*P+1.d0)
         H = D(L) - E(L) / (P + DSIGN(R,P))
         DO  I = L, N
         D(I) = D(I) - H
         end do
         F = F + H
         P = D(M)
         C = 1.d0
         S = 0.d0
         MML = M - L
         DO 200 II = 1, MML
            I = M - II
            G = C * E(I)
            H = C * P
            IF (DABS(P) .LT. DABS(E(I))) GO TO 150
            C = E(I) / P
            R = DSQRT(C*C+1.d0)
            E(I+1) = S * P * R
            S = C / R
            C = 1.d0 / R
            GO TO 160
  150       C = P / E(I)
            R = DSQRT(C*C+1.d0)
            E(I+1) = S * E(I) * R
            S = 1.d0 / R
            C = C * S
  160       P = C * D(I) - S * G
            D(I+1) = H + S * (C * G + S * D(I))
            DO  K = 1, N
               H = ZR(K,I+1)
               ZR(K,I+1) = S * ZR(K,I) + C * H
               ZR(K,I) = C * ZR(K,I) - S * H
            end do
  200    CONTINUE
         E(L) = S * P
         D(L) = C * P

         IF (DABS(E(L)) .GT. B) GO TO 130
         
  220    D(L) = D(L) + F
  240 CONTINUE
  
      DO  II = 2, N
         I = II - 1
         K = I
         P = D(I)
         DO  J = II, N
            IF (D(J) .GE. P) cycle
            K = J
            P = D(J)
           end do
         IF (K .EQ. I) cycle
         D(K) = D(I)
         D(I) = P
         DO  J = 1, N
            P = ZR(J,I)
            ZR(J,I) = ZR(J,K)
            ZR(J,K) = P
         end do
          end do


      GO TO 1001
 1000 IERR = L
 1001   continue
 
    RETURN
      END
!**************************************************

        SUBROUTINE dxdydz(dx,dy,dz,romin,i11,i22)
          use common_var
         real*8:: romin,dx0,dy0,dz0,ro,x1,x2,y1,y2,z1,z2 
        real*8::dx,dy,dz,dxmin,dymin,dzmin  
        integer:: i11,i22,i1,i2,i3 

        x1=x(i11)
        y1=y(i11)
        z1=z(i11)

        x2=x(i22)
        y2=y(i22)
        z2=z(i22)

        dx=x2-x1
        dy=y2-y1
        dz=z2-z1
        romin=dsqrt(dx**2+dy**2+dz**2)
!c********** Periodic conditions **********
            if(i11==i22) return
           dxmin=dx; dymin=dy; dzmin=dz
        do i1=-1,1
        do i2=-1,1
        do i3=-1,1
        if((i1+10*i2+100*i3)==0) cycle
        x2=x(i22)+dfloat(i1)*perx(1)+dfloat(i2)*perx(2)+dfloat(i3)*perx(3)
        y2=y(i22)+dfloat(i1)*pery(1)+dfloat(i2)*pery(2)+dfloat(i3)*pery(3)        
        z2=z(i22)+dfloat(i1)*perz(1)+dfloat(i2)*perz(2)+dfloat(i3)*perz(3)
        dx0=x2-x1
        dy0=y2-y1
        dz0=z2-z1
        ro=dsqrt(dx0**2+dy0**2+dz0**2)

        if(ro<romin)then
        romin=ro
        dxmin=dx0; dymin=dy0; dzmin=dz0
        end if
        
        end do
        end do
        end do          

        dx=dxmin; dy=dymin; dz=dzmin

        return
        end
!*************************************************************

!**************************************************

        SUBROUTINE min4()
          use common_var
         real*8:: Emin
        integer:: i
    imin4=1
    Emin=Emin4(1)
    do i=2,4
    if(Emin4(i)<Emin) then
    imin4=i
    Emin=Emin4(i)
    end if
    end do
        return
        end
!*************************************************************
