! ************************************************************
    module drive  ! Parameters of HCNO potential
        integer:: ntype ! =0 for quick rel.,-1 saddle, +1 min, 2 spect
        real*8 :: step,dsig
        real*8 ::  visc(4)   !  viscosity for marked atoms
        integer:: N_max, StepWrite 
        real*8 :: tolerance
    
    end module drive
! ************************************************************
    module param  ! Parameters of HCNO potential
      real*8 fi0(4,4),betta(4,4),R0(4,4)
      real*8 K0(4,4),delta(4,4)
      real*8 H(4,2),ksi(4,2)
    end module param
!c ************************************************************
    module common_var
      real*8, parameter:: pi=3.14159265d0
      real*8, parameter:: bohr=1.889725989
      real*8,allocatable:: x(:),y(:),z(:) ! Atomic coordinates
      real*8,allocatable:: x0(:),y0(:),z0(:) ! Atomic coordinates
      real*8,allocatable:: x_new(:),y_new(:),z_new(:)
      real*8,allocatable:: vx(:),vy(:),vz(:) ! Velocities of atoms
      real*8,allocatable:: fx(:),fy(:),fz(:) ! Force components
      real*8,allocatable:: vfx(:),vfy(:),vfz(:) ! Force components
      real*8,allocatable:: fx0(:),fy0(:),fz0(:) ! Force components
      real*8,allocatable:: felx(:),fely(:),felz(:) ! electron Force components
      real*8,allocatable:: frepx(:),frepy(:),frepz(:) ! Repuls. Force components
      real*8,allocatable:: amass(:) ! masses of atoms
      real*8:: atmass(4) ! masses of atoms
      real*8,allocatable:: Hess(:,:) ! Hessian
      real*8,allocatable:: Hesel(:,:),hesrep(:,:) ! Hessian
      real*8,allocatable:: delta3(:) ! minsad displacement
      real*8,allocatable::  dS(:,:),dHam(:,:),Ham(:,:)
 
      real*8,allocatable:: ddd(:),e1(:) ! spectrum attributes
      integer,allocatable:: at_type(:) ! Types of atoms: H=1, C=2, N=3, O=4
      integer H_count,C_count,N_count,O_count ! The number of different types atoms
      integer at_count ! Total number of atoms
      integer Nat3 ! Total number of generelised coordinates = 3*at_count
      integer el_count,wfunc_count ! Number of electron and orbitals
           integer:: na1,na2 
          real*8 ::   Ff12
           integer:: na3,na4
          real*8 ::   Ff34
           integer:: na5,na6
          real*8 ::   Ff56
           integer:: na7,na8
          real*8 ::   Ff78
          real*8 ::perx(3),pery(3),perz(3)
          real*8 ::perx0(3),pery0(3),perz0(3)
      real*8 :: dt
      real*8 :: temp
      character (LEN =8) read_or_zero
      integer :: StepToWrite_MD 
      integer :: MaxStepToWrite_MD
      integer :: par_MD_read
      integer :: iterMAX, NNNN, MMMM, n_thermal
      real*8  :: alpha
      real*8  :: Emin4(4)
      integer :: imin4
      integer :: iepsXX,iepsYY,iepsZZ,iepsXY,iepsXZ,iepsYZ 
      integer :: k_relax
      character (LEN =10) type_coord
	  
      real*8, parameter :: tol_vc = 1e-24




    end module common_var



    module convert2frac
    contains
        subroutine cart2frac(natoms, cell_v, cart_coord, frac_coord)
        implicit none

        integer(4), intent(in) :: natoms
        real(8), intent(in) :: cell_v(3,3)
        real(8), intent(in) :: cart_coord(natoms,3)
        real(8), intent(out) :: frac_coord(natoms,3)

        integer :: i, j
        real(8) :: latCnt(3,3)
        real(8) :: detLatCnt
        real(8) :: mas_a(3,3), mas_b(3,3), mas_c(3,3)

        do i = 1, 3
            do j = 1,3
                latCnt(i,j) = cell_v(j,i)
            enddo
        enddo

        detLatCnt = det3(latCnt)

        do i = 1,natoms
            mas_a = reshape((/ cart_coord(i,1), cart_coord(i,2), cart_coord(i,3), latCnt(1,2), &
            latCnt(2,2), latCnt(3,2), latCnt(1,3), latCnt(2,3), latCnt(3,3) /), shape(mas_a))
    
            mas_b = reshape((/ latCnt(1,1), latCnt(2,1), latCnt(3,1), cart_coord(i,1), &
            cart_coord(i,2), cart_coord(i,3), latCnt(1,3), latCnt(2,3), latCnt(3,3) /), shape(mas_b))
    
            mas_c = reshape((/ latCnt(1,1), latCnt(2,1), latCnt(3,1), latCnt(1,2), latCnt(2,2), &
            latCnt(3,2), cart_coord(i,1), cart_coord(i,2), cart_coord(i,3) /), shape(mas_c))
        
            frac_coord(i,1) = det3(mas_a) / detLatCnt
            frac_coord(i,2) = det3(mas_b) / detLatCnt
            frac_coord(i,3) = det3(mas_c) / detLatCnt
        enddo

        end subroutine cart2frac
        
        function det3(mat) result(det)
        implicit none

        real(8), intent(in) :: mat(3,3)
        real(8) :: det

        det = mat(1,1)*mat(2,2)*mat(3,3) + mat(1,2)*mat(2,3)*mat(3,1) + mat(1,3)*mat(2,1)*mat(3,2) - &
              mat(1,3)*mat(2,2)*mat(3,1) - mat(1,2)*mat(2,1)*mat(3,3) - mat(1,1)*mat(2,3)*mat(3,2)

        end function det3
	
    end module convert2frac
