        SUBROUTINE Hess_cre
    use param
    use common_var
        implicit real *8(a-h,o-z)

    integer i,j,k1
        real*8:: dd,eee
        real*8:: dx,dy,dz,r,r2,arg,expon,bet,L,M,N 
        real*8::  sxx,syy,szz,sxy 

        x0=x;  y0=y;  z0=z;

        dd=1.e-4
         
!*************  Electron part ***************************
        do i=1,at_count
        x(i)=x(i)-dd
        call force(eee)

        do j=1,at_count
        fx0(j)=felx(j)
        fy0(j)=fely(j)
        fz0(j)=felz(j)
        end do

        x(i)=x(i)+2.*dd 
        call force(eee)

        do j=1,at_count
        hesel(1+3*(i-1),1+3*(j-1))=-0.5*(felx(j)-fx0(j))/dd
        hesel(1+3*(i-1),2+3*(j-1))=-0.5*(fely(j)-fy0(j))/dd
        hesel(1+3*(i-1),3+3*(j-1))=-0.5*(felz(j)-fz0(j))/dd
        end do
        x(i)=x(i)-dd 


        y(i)=y(i)-dd 
        call force(eee)

        do j=1,at_count
        fx0(j)=felx(j)
        fy0(j)=fely(j)
        fz0(j)=felz(j)
        end do

        y(i)=y(i)+2.*dd 
        call force(eee)

        do j=1,at_count
        hesel(2+3*(i-1),1+3*(j-1))=-0.5*(felx(j)-fx0(j))/dd
        hesel(2+3*(i-1),2+3*(j-1))=-0.5*(fely(j)-fy0(j))/dd
        hesel(2+3*(i-1),3+3*(j-1))=-0.5*(felz(j)-fz0(j))/dd
        end do
        y(i)=y(i)-dd 


        z(i)=z(i)-dd
        call force(eee)

        do j=1,at_count
        fx0(j)=felx(j)
        fy0(j)=fely(j)
        fz0(j)=felz(j)
        end do

        z(i)=z(i)+2.*dd
        call force(eee)

        do j=1,at_count
        hesel(3+3*(i-1),1+3*(j-1))=-0.5*(felx(j)-fx0(j))/dd
        hesel(3+3*(i-1),2+3*(j-1))=-0.5*(fely(j)-fy0(j))/dd
        hesel(3+3*(i-1),3+3*(j-1))=-0.5*(felz(j)-fz0(j))/dd
        end do
        z(i)=z(i)-dd

        end do
!************* End Electron part ***************************


!*************  Repuls part ***************************
        do i=1,at_count


        do j=1,at_count  !  (X,XYZ)

         Sxx=0.d0; Sxy=0.d0; Sxz=0.d0
                   Syy=0.d0; Syz=0.d0
                             Szz=0.d0
             if(i==j) then  !!!!!!!!!!!!!!!
         do k1=1,at_count
     if(i==k1) cycle
        call  dxdydz(dx,dy,dz,R,i,k1)
                l=dx/R; m=dy/R; n=dz/R 

          r2=r**2
     bet=-betta(at_type(i),at_type(k1))
     arg=bet*(r-R0(at_type(i),at_type(k1)))
     expon=bet*dexp(arg)
     expon=fi0(at_type(i),at_type(k1))*expon/r2
     Sxx=Sxx+expon*(dx**2*bet+(dy**2+dz**2)/r ) 
     Sxy=Sxy+expon*(dx*dy*bet-dx*dy/r )
      Sxz=Sxz+expon*(dx*dz*bet-dx*dz/r ) 
     Syy=Syy+expon*(dy**2*bet+(dx**2+dz**2)/r )
     Syz=Syz+expon*(dy*dz*bet-dy*dz/r )
     Szz=Szz+expon*(dz**2*bet+(dx**2+dy**2)/r )
     end do

             else

        call  dxdydz(dx,dy,dz,R,j,i)
                l=dx/R; m=dy/R; n=dz/R 
          r2=r**2  
      bet=-betta(at_type(i),at_type(j))
     arg=bet*(r-R0(at_type(i),at_type(j)))
     expon=bet*dexp(arg)
     expon=fi0(at_type(i),at_type(j))*expon/r2
     Sxx=Sxx-expon*(dx**2*bet+(dy**2+dz**2)/r ) 
     Sxy=Sxy-expon*(dx*dy*bet-dx*dy/r )
     Sxz=Sxz-expon*(dx*dz*bet-dx*dz/r )
   Syy=Syy-expon*(dy**2*bet+(dx**2+dz**2)/r )
   Syz=Syz-expon*(dy*dz*bet-dy*dz/r )
   Szz=Szz-expon*(dz**2*bet+(dx**2+dy**2)/r )

             end if   !!!!!!!!!!!!!!!!!!!!
    hesrep(1+3*(i-1),1+3*(j-1))=Sxx   !  XX
    hesrep(1+3*(i-1),2+3*(j-1))=Sxy   !  XY
    hesrep(1+3*(i-1),3+3*(j-1))=Sxz   !  XZ
    hesrep(2+3*(i-1),1+3*(j-1))=Sxy   !  YX
    hesrep(2+3*(i-1),2+3*(j-1))=Syy   !  YY
    hesrep(2+3*(i-1),3+3*(j-1))=Syz   !  YZ
    hesrep(3+3*(i-1),1+3*(j-1))=Sxz   !  ZX
    hesrep(3+3*(i-1),2+3*(j-1))=Syz   !  ZY
    hesrep(3+3*(i-1),3+3*(j-1))=Szz   !  ZZ
    
        end do

        end do  !  End  i - cycle
!************* End  Repuls part ***************************
        hess=hesel+hesrep  


!****   Symmetrization  *********
       do i=1,at_count
       do j=i,at_count
        dd=(hess(i,j)+hess(j,i))/2.d0
        hess(j,i)=dd 
        hess(i,j)=dd 
        end do
        end do
!********************************


        RETURN       

        END
 
