subroutine hyperMD
  use common_var
  implicit real*8 (a-z)
  real*8 time,e, kT
  real*8 Ucut
  character(4) s
  character(1) initU, range,fl
  integer iMMMM,iternum, iter
  integer rand1, rand2
  real*8 tMMMM,sMMMM,tsrednee
  integer j1,j, iiii
  allocate (vx(at_count),vy(at_count),vz(at_count))
  allocate (vfx(at_count),vfy(at_count),vfz(at_count))
  print*, 'Input temp(K)=', temp
  print*, 'Time Step=', dt


  kT=temp/11602.d0
  call set_rand(1886,1987)
  print*, "RANDOM GENERATOR:"
  print*, "Input two integer numbers (example: 1986 5417):"
  read(*,*) rand1, rand2
  call set_rand(rand1,rand2)
  s='HCNO'
  Ucut=-1.d8; iter=0

  do j1=1,at_count
      vx(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
      vy(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
      vz(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
  enddo
  
  do iiii=1,n_thermal
      do j=1,at_count
          x(j)=x(j)+vx(j)*dt+0.5d0*fx(j)*dt*dt/atmass(at_type(j))
          y(j)=y(j)+vy(j)*dt+0.5d0*fy(j)*dt*dt/atmass(at_type(j))
          z(j)=z(j)+vz(j)*dt+0.5d0*fz(j)*dt*dt/atmass(at_type(j))
          vfx(j)=fx(j); vfy(j)=fy(j); vfz(j)=fz(j)
      enddo
      call force(e)
      if (e.lt.Ucut) then
          e=Ucut-alpha*(Ucut-e)
          do j=1,at_count
              fx(j)=alpha*fx(j); fy(j)=alpha*fy(j); fz(j)=alpha*fz(j)
          enddo
      endif
      do j=1,at_count
          vx(j)=vx(j)+0.5d0*dt*(vfx(j)+fx(j))/atmass(at_type(j))
          vy(j)=vy(j)+0.5d0*dt*(vfy(j)+fy(j))/atmass(at_type(j))
          vz(j)=vz(j)+0.5d0*dt*(vfz(j)+fz(j))/atmass(at_type(j))
      enddo
  enddo

  Ucut=-1.d8; Emax=Ucut; iternum=0; iNNNN=0; iMMMM=0; sMMMM=0.d0; tMMMM=0.d0; initU='y'; range='u'; tsrednee=0.d0

  
  time=0.d0; call force(e)
  do 
      iter=iter+1
      if (iter>iterMAX) then
          deallocate (vx,vy,vz,vfx,vfy,vfz)
          print*, 'Maximum number of iterations are reached!'
          print*, '****************************'
          print*, 'HYPER MOLECULAR DYNAMIC CALCULATIONS COMPLETE!'
          call EXIT()
      endif
      
      do j=1,at_count
          x(j)=x(j)+vx(j)*dt+0.5d0*fx(j)*dt*dt/atmass(at_type(j))
          y(j)=y(j)+vy(j)*dt+0.5d0*fy(j)*dt*dt/atmass(at_type(j))
          z(j)=z(j)+vz(j)*dt+0.5d0*fz(j)*dt*dt/atmass(at_type(j))
          vfx(j)=fx(j); vfy(j)=fy(j); vfz(j)=fz(j)
      enddo
      call force(e)
      if (e.lt.Ucut) then
          e=Ucut-alpha*(Ucut-e)
          do j=1,at_count
              fx(j)=alpha*fx(j); fy(j)=alpha*fy(j); fz(j)=alpha*fz(j)
          enddo
      endif
      do j=1,at_count
          vx(j)=vx(j)+0.5d0*dt*(vfx(j)+fx(j))/atmass(at_type(j))
          vy(j)=vy(j)+0.5d0*dt*(vfy(j)+fy(j))/atmass(at_type(j))
          vz(j)=vz(j)+0.5d0*dt*(vfz(j)+fz(j))/atmass(at_type(j))
      enddo
         
      if (e.gt.Ucut) then
          time=time+dt; range='u'
      endif
      if (e.le.Ucut) then
          if (range.eq.'u') then    
              range='d'; time=time+tsrednee
          endif
      endif
    

      if (initU.eq.'y') then
          iNNNN=iNNNN+1
          if (e.gt.Emax) then
              Emax=e
          endif
          fl='n' 
      endif

      if (initU.eq.'n') then
          if (e.gt.Emax) then
              if (fl.eq.'n') then
                  fl='y'; sMMMM=sMMMM+(time-tMMMM); iMMMM=iMMMM+1
                  open(1,file='hmd.info',access='append'); write(1,*) 'iMMMM=',iMMMM,'tMMMM=',time-tMMMM; close(1)
              endif
          endif

          if (e.le.Emax) then
              if (fl.eq.'y') then
                  fl='n'; tMMMM=time
              endif
          endif
      endif

      if (iNNNN.gt.NNNN) then  
          iNNNN = 0; initU='n'; tMMMM=time
      endif     

      if (iMMMM.ge.MMMM) then  
          tsrednee=sMMMM/dfloat(MMMM)
          Ucut=Emax; iternum=iternum+1; iNNNN=0; iMMMM=0; sMMMM=0.d0; initU='y'; range='d'
          open(1,file='hmd.info',access='append'); write(1,*) 'tsrednee=',tsrednee,'Ucut=',Ucut,'iter=',iter,'time=',time; close(1)
      endif     

      if  (rndm().gt.0.99) then
          do j1=1,at_count
              vx(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
              vy(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
              vz(j1)=gaus(0.d0,kT/atmass(at_type(j1)))
          enddo
      endif
 
      if (mod(iter,StepToWrite_MD).eq.0) then
          call wri_crd_MD(time, iter)
      endif

  enddo

  deallocate (vx,vy,vz,vfx,vfy,vfz)
  call EXIT()
end subroutine hyperMD
