subroutine MD_Verlet
  use common_var
  real*8 time, e, time_old
  character(4) s
  integer j,iter, new_j, new_jj
  real*8 vx_old(at_count), vy_old(at_count), vz_old(at_count)

  allocate (vx(at_count),vy(at_count),vz(at_count))
  allocate (vfx(at_count),vfy(at_count),vfz(at_count))
  
  print*, 'Time Step=', dt

  s='HCNO'
  if (par_MD_read == 1) then
      vx = 0
      vy = 0
      vz = 0
  else
      open(42,file='velocity.ini')
      do i=1,at_count
          read(42,*) vx(i), vy(i), vz(i)
      enddo
      close(42)
  endif
  
  time=0.d0; iter=0; call force(e)

  do new_j=1, MaxStepToWrite_MD
      vx_old = vx
      vy_old = vy
      vz_old = vz
      time_old = time
      do new_jj=1, StepToWrite_MD
          do j=1,at_count
              x(j)=x(j)+vx(j)*dt+0.5d0*fx(j)*dt*dt/atmass(at_type(j))
              y(j)=y(j)+vy(j)*dt+0.5d0*fy(j)*dt*dt/atmass(at_type(j))
              z(j)=z(j)+vz(j)*dt+0.5d0*fz(j)*dt*dt/atmass(at_type(j))
              vfx(j)=fx(j); vfy(j)=fy(j); vfz(j)=fz(j)
          enddo
          call force(e)
          do j=1,at_count         
              vx(j)=vx(j)+0.5d0*dt*(vfx(j)+fx(j))/atmass(at_type(j))
              vy(j)=vy(j)+0.5d0*dt*(vfy(j)+fy(j))/atmass(at_type(j))
              vz(j)=vz(j)+0.5d0*dt*(vfz(j)+fz(j))/atmass(at_type(j))
          enddo
          time=time+dt; iter=iter+1
      enddo
      print*, 'Iteration =', iter,';', ' time (fs)=', time

      call wri_crd_MD(time,new_j)
      open(1,file='velocity.out')
           write(1,*) 'Step = ', MaxStepToWrite_MD, 'time = ', time
           do j=1,at_count
               write(1,*) vx(j), vy(j), vz(j)
           enddo
           write(1,*) 'Step = ', (MaxStepToWrite_MD-1), 'time = ', time_old
           do j=1,at_count
               write(1,*) vx_old(j), vy_old(j), vz_old(j)
           enddo
      close(1)
  enddo

  deallocate (vx,vy,vz,vfx,vfy,vfz)
  print*, '****************************'
  print*, 'MOLELUCLAR DYNAMIC CALCULATIONS COMPLETE!'
  call EXIT()

end subroutine MD_Verlet
